/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.ECStream;
import com.ibm.hwmca.base.updates.MCF;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FilenameFilter;

class AllMCFFileFilter
implements FilenameFilter {
    private static final String TRACE_MASKT = "XMCLMZFT";
    private static final String TRACE_MASKF = "XMCLMZFF";
    private static final String TRACE_MASKD = "XMCLMZFD";
    private static final int MCF_FILE_NAME_LENGTH = 14;
    private static final int MCF_FILE_NAME_DOT_POS = 10;
    private static final String MCF_FILE_NAME_ZIP = ".ZIP";
    String ecStream;
    int ecStreamLength;

    public AllMCFFileFilter(ECStream ec) {
        this.ecStream = ec.getECNumber().toUpperCase();
        this.ecStreamLength = this.ecStream.length();
        Trace.trace(TRACE_MASKT, "<> AllMCFFileFilter for [" + this.ecStream + "]");
    }

    public boolean accept(File dir, String name) {
        Trace.trace(TRACE_MASKD, "-> accept(" + name + ")");
        boolean inec = false;
        if (14 != name.length()) {
            Trace.trace(TRACE_MASKD, "<- accept() returns " + inec);
            return inec;
        }
        try {
            int dotPosition;
            char firstChar = name.charAt(0);
            MCF.determineMCFType(name);
            String compareString = name.substring(1, 1 + this.ecStreamLength).toUpperCase();
            Trace.trace(TRACE_MASKD, "compareString = [" + compareString + "], " + "this.ecStream = [" + this.ecStream + "]");
            if (compareString.equals(this.ecStream) && 10 == (dotPosition = name.indexOf(".")) && name.substring(dotPosition).toUpperCase().equals(MCF_FILE_NAME_ZIP)) {
                inec = true;
            }
        }
        catch (HException e) {
            // empty catch block
        }
        Trace.trace(TRACE_MASKD, "<- accept() returns " + inec);
        return inec;
    }
}

